------------------------------------------------------------
------------------------------------------------------------
------------------------------------------------------------
function updateMorale(merc, mod, event)
	
	if ((merc == nil) or (merc == "")) then
		log("morale", "wrong merc:", merc)
		return
	end
	
	local mercs = {}
	
	if (type(merc) ~= "table") then
		mercs = { merc }
	else
		mercs = merc
	end

	local update = function(index, name)
		
		local morale = getPersonParameter(name, "MORALE")
		local new_morale = morale + mod
		
		if (new_morale < 0) then 
			new_morale = 0
		elseif (new_morale > 100) then
			new_morale = 100
		end
		
		setPersonParameter(name, "MORALE", new_morale)
		
		log("morale_system", index, name, "had morale:", morale, "now has morale:", new_morale, "event: ", event)
		
	end
	
	table.foreach(mercs, update)
	
	moraleWatcher()
	
end

function moraleWatcher()

	local all_mercs = Mercs
	
	local check = function(name, info)
		

		if ((info.hired == true) and (info.alive == true)) then
			
			local health = getPersonParameter(name, "HEALTH")
			
			if (health >= 15) then
		
				local morale = getPersonParameter(name, "MORALE")
				
				if (morale < info.mt) then
					local rnd = math.random()
					
					log("morale_system", name, "morale:", morale, "mt:", info.mt, "rnd:", rnd)
					
					if (rnd > (info.mt / 100)) then
						dismissMerc(name, "_hire_refuse_lazy")
						
						local hmercs = getHiredMercs(true)
						
						updateMorale(hmercs, MoralePenalty.TINY, name, "leaves due to low morale")
						
						if (service.checkPlayerUnits(PLAYER) == false) then
							if (CUR_MISSION.Finishing ~= true) then
								if (CUR_MISSION.Failed == true) then
									if (BATTLE_DATA.Enabled == true) then
										Sectors[BATTLE_DATA.Sector].owner = BATTLE_DATA.Attacker
									end

									CUR_MISSION.KillTime = MISSION_TIME
									Triggers["end_trigger"].active = true
									
									CUR_MISSION.Finishing = true
								end
							end
						end
					end
				end
			end
		end
	end
	
	table.foreach(all_mercs, check)
	
end
